// --- 如何修改下面的 "EMX配件数据" 对象 ---
//
// 1. 整体结构:
//    `EMX配件数据` 是一个JavaScript对象 (Object)。
//    它包含了一系列的键值对 (key-value pairs)。
//
// 2. 每个配件条目:
//    - "键" (Key): 是配件的唯一ID，格式为 "命名空间:配件文件名_data"。
//      例如: "emxarms:sight_emx_char2_ev_data"
//      - "emxarms": 这是你指定的命名空间。
//      - "sight_emx_char2_ev": 这通常对应你的原始JSON文件名 (去掉了 "_data.json" 后缀)。
//      - "_data": 这是TaCZ模组加载配件数据时通常期望的后缀。
//      **非常重要**: 这个ID必须与服务器实际尝试加载的配件ID完全一致，你的修改才会生效。
//
//    - "值" (Value): 是另一个JavaScript对象，包含了该配件的所有具体属性。
//      例如: { "weight": 0.2, "ads_addend": -0.06, ... }
//
// 3. 修改/添加配件数据:
//    - 要修改一个已存在的配件:
//      a. 找到对应的 "命名空间:配件ID_data" 键。
//      b. 修改其 "值" 对象中的属性。
//
//    - 要添加一个新的配件 (如果TaCZ会尝试加载这个ID的话):
//      a. 在 `EMX配件数据 = { ... }` 的大括号内，添加一个新的键值对。
//      b. 键是新配件的 "命名空间:配件ID_data"。
//      c. 值是一个包含新配件属性的对象。
//      d. **注意**: 每个键值对之间用逗号 `,` 分隔，但最后一个键值对后面不要加逗号。
//
// 4. 修改配件属性:
//    在每个配件的 "值" 对象内部，你可以修改具体的属性，例如:
//    - "weight": 0.2,            // 数字类型，代表重量
//    - "ads_addend": -0.06,      // 数字类型，瞄准时间加成
//    - "inaccuracy_addend": -0.1, // 数字类型，散射加成
//    - "recoil_modifier": {      // 对象类型，包含更详细的后坐力修改
//        "pitch": -0.05        // 数字类型，垂直后坐力修正
//      },
//    - "damage": {               // 对象类型，伤害修正
//        "multiplier": 1.1     // 数字类型，伤害乘数
//      },
//    - "melee": {                // 对象类型，近战属性
//        "damage": 21,
//        "effects": [            // 数组类型，包含多个效果对象
//          { "id": "minecraft:slowness", "time": 10, "amplifier": 2 }
//        ]
//      }
//
//    - 属性的名称 (如 "weight", "ads", "percent", "multiplier", "addend") 和它们的作用
//      是由TaCZ模组和你的emxarms数据定义的。你需要参考原始JSON文件或相关文档
//      来了解每个字段的确切含义和允许的值。
//
//    - 值的类型:
//      - 数字: 例如 `0.2`, `-0.05`
//      - 字符串: 例如 `"minecraft:slowness"` (通常用双引号包围)
//      - 布尔值: `true` 或 `false`
//      - 对象: 用 `{}` 包围，内部可以有更多键值对
//      - 数组: 用 `[]` 包围，内部可以有多个值或对象
//
// 5. 语法要点:
//    - 所有的 "键" (属性名) 都必须用双引号 `"` 包围，例如 `"weight"`。
//    - 字符串 "值" 也必须用双引号 `"` 包围。
//    - 对象内的键值对之间用逗号 `,` 分隔。
//    - 数组内的元素之间用逗号 `,` 分隔。
//    - 对象的最后一个键值对 或 数组的最后一个元素 后面 **不加** 逗号。
//
// 6. 示例 - 修改 `emxarms:sight_emx_char2_ev_data` 的重量和后坐力:
//    假设原始是:
//    "emxarms:sight_emx_char2_ev_data": {
//        "weight": 0.2,
//        "ads_addend": -0.06,
//        "inaccuracy_addend": -0.1,
//        "recoil_modifier": {
//            "pitch": -0.05 // 原垂直后坐力修正
//        }
//    },
//
//    修改后可能变成:
//    "emxarms:sight_emx_char2_ev_data": {
//        "weight": 0.25, // 重量从 0.2 修改为 0.25
//        "ads_addend": -0.06,
//        "inaccuracy_addend": -0.1,
//        "recoil_modifier": {
//            "pitch": -0.08, // 垂直后坐力修正从 -0.05 修改为 -0.08
//            "yaw": -0.02    // 新增了水平后坐力修正
//        }
//    },
//
// 7. 生效:
//    修改并保存此 `.js` 文件后，你需要重启你的Minecraft服务器，
//    或者如果KubeJS支持，使用 `/kubejs reload_startup_scripts` (或类似命令)
//    来使更改生效。
//
// --- 开始你的修改 ---

// const EMX配件数据 = {
//   "emxarms:ammo_sgdb_data": { ... },
//   "emxarms:ammo_sgeb_data": { ... },
//   ... 更多你的数据 ...
// };

let EMX配件数据 = {
    "emxarms:ammo_sgdb_data": {
        "weight": 1.0,
        "ads": { "percent": -0.08 },
        "inaccuracy": { "addend": -0.15 },
        "aim_inaccuracy": { "addend": -0.12 },
        "ammo_speed": { "percent": -0.3 },
        "pierce": { "addend": 0.2 },
        "rpm": { "multiplier": 0.95 },
        "extended_mag_level": 2,
        "ignite": { "entity": true },
        "damage": { "multiplier": 1.3 },
        "knockback": { "addend": 0.5 }
    },
    "emxarms:ammo_sgeb_data": {
        "weight": 0.8,
        "ads": { "percent": 0.15 },
        "inaccuracy": { "addend": 0.25 },
        "aim_inaccuracy": { "addend": 0.15 },
        "ammo_speed": { "percent": 0.08 },
        "pierce": { "addend": -0.5 },
        "rpm": { "multiplier": 0.8 },
        "extended_mag_level": 2,
        "recoil": {
            "yaw": { "percent": 0.15 },
            "pitch": { "percent": 0.34 }
        },
        "damage": { "multiplier": 1.6 },
        "armor_ignore":{ "multiplier": 0.0 },
        "head_shot":{ "addend": -0.2 },
        "knockback": { "addend": 0.2 }
    },
    "emxarms:ammo_sgfs_data": {
        "weight": 1.25,
        "ads": { "percent": 0.16 },
        "inaccuracy": { "addend": 0.15 },
        "aim_inaccuracy": { "addend": 0.12 },
        "ammo_speed": { "percent": 0.08 },
        "pierce": { "addend": 1.5 },
        "extended_mag_level": 3,
        "damage": { "multiplier": 0.75 },
        "armor_ignore":{ "addend": 0.05 },
        "head_shot":{ "addend": -0.12 }
    },
    "emxarms:ammo_sghe_data": {
        "weight": 1.25,
        "ads": { "percent": 0.2 },
        "inaccuracy": { "addend": 0.15 },
        "aim_inaccuracy": { "addend": 0.12 },
        "ammo_speed": { "percent": -0.08 },
        "pierce": { "addend": -0.1 },
        "rpm": { "multiplier": 0.9 },
        "extended_mag_level": 2,
        "damage": { "multiplier": 0.9 },
        "head_shot":{ "addend": 0.17 },
        "knockback": { "addend": 0.5 }
    },
    "emxarms:ammo_sh2_data": {
        "weight": 0.8,
        "ads": { "addend": 0.08 },
        "damage": { "multiplier": 1.2 },
        "extended_mag_level": 2
    },
    "emxarms:ammo_sh1_data": {
        "weight": 0.6,
        "ads": { "addend": 0.06 },
        "damage": { "multiplier": 1.1 },
        "extended_mag_level": 1
    },
    "emxarms:ammo_sh2_if_data": {
        "weight": 1.2,
        "ads": { "percent": -0.04 },
        "inaccuracy": { "addend": 0.27 },
        "aim_inaccuracy": { "addend": 0.14 },
        "ammo_speed": { "percent": -0.2 },
        "rpm": { "multiplier": 0.95 },
        "extended_mag_level": 2,
        "ignite": { "entity": true },
        "damage": { "multiplier": 1.15 },
        "head_shot":{ "addend": 0.04 }
    },
    "emxarms:ammo_sh3_data": {
        "weight": 1.8,
        "ads": { "addend": 0.15 },
        "damage": { "multiplier": 1.15 },
        "extended_mag_level": 3
    },
    "emxarms:ammo_sh3r_data": {
        "weight": 3.2,
        "ads": { "addend": 0.15 },
        "damage": { "multiplier": 1.2 },
        "extended_mag_level": 3
    },
    "emxarms:ammo_sreb_data": {
        "weight": 1.6,
        "ads": { "percent": 0.1 },
        "inaccuracy": { "addend": 0.25 },
        "aim_inaccuracy": { "addend": 0.15 },
        "ammo_speed": { "percent": 0.08 },
        "pierce": { "addend": -1.0 },
        "rpm": { "multiplier": 0.8 },
        "extended_mag_level": 2,
        "recoil": {
            "yaw": { "percent": 0.15 },
            "pitch": { "percent": 0.34 }
        },
        "damage": { "multiplier": 1.3 },
        "armor_ignore":{ "multiplier": 0.0 },
        "head_shot":{ "addend": -0.3 },
        "knockback": { "addend": 0.2 }
    },
    "emxarms:ammo_srhe_data": {
        "weight": 1.25,
        "ads": { "percent": 0.2 },
        "inaccuracy": { "addend": 0.15 },
        "aim_inaccuracy": { "addend": 0.12 },
        "ammo_speed": { "percent": -0.08 },
        "pierce": { "addend": -0.1 },
        "rpm": { "multiplier": 0.9 },
        "extended_mag_level": 2,
        "explosion": {
            "explode": true,
            "radius": { "addend": 1.5 },
            "damage": { "addend": 15.0 },
            "knockback": false,
            "destroy_block": false,
            "delay": { "addend": 3.0 }
        },
        "damage": { "multiplier": 0.9 },
        "head_shot":{ "addend": 0.17 },
        "knockback": { "addend": 0.5 }
    },
    "emxarms:ammo_srif_data": {
        "weight": 1.2,
        "ads": { "percent": -0.08 },
        "inaccuracy": { "addend": 0.15 },
        "aim_inaccuracy": { "addend": 0.12 },
        "ammo_speed": { "percent": -0.13 },
        "pierce": { "addend": -1.0 },
        "rpm": { "multiplier": 1.02 },
        "extended_mag_level": 2,
        "ignite": { "entity": true },
        "damage": { "multiplier": 1.2 },
        "armor_ignore":{ "addend": -0.04 },
        "knockback": { "addend": 0.5 }
    },
    "emxarms:bayonet_emx_atomic_data": {
        "weight": 0.34,
        "ads_addend": 0.05,
        "melee": {
            "range": [5, 1, 2],
            "damage": 21,
            "knockback": 0.0,
            "cooldown": -0.3,
            "delay_damage_time": 0.2
        }
    },
    "emxarms:bayonet_emx_doom_data": {
        "weight": 1.0,
        "recoil_modifier": {
            "pitch": -0.36,
            "yaw": -0.14
        },
        "melee": {
            "range": [6, 1, 2],
            "damage": 45,
            "knockback": 3.0,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:slowness", "time": 10, "amplifier": 2, "hide_particles": true },
                { "id": "minecraft:weakness", "time": 10, "amplifier": 2, "hide_particles": true }
            ]
        }
    },
    "emxarms:bayonet_emx_glowsword_data": {
        "weight": 0.21,
        "ads_addend": 0.05,
        "melee": {
            "range": [6, 1, 2],
            "damage": 30,
            "cooldown": -0.2,
            "knockback": 0.0,
            "delay_damage_time": 0.2
        }
    },
    "emxarms:bayonet_emx_lightupgrade_data": {
        "weight": -0.5,
        "ads_addend": -0.01,
        "melee": {
            "range": [5, 1, 2],
            "damage": 11,
            "knockback": 1.2,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:slowness", "time": 3, "amplifier": 2, "hide_particles": true },
                { "id": "minecraft:weakness", "time": 5, "amplifier": 2, "hide_particles": true }
            ]
        }
    },
    "emxarms:bayonet_emx_skyhunter_data": {
        "weight": 0.34,
        "ads_addend": 0.05,
        "melee": {
            "range": [5, 1, 2],
            "damage": 10,
            "knockback": 0.0,
            "cooldown": -0.2,
            "delay_damage_time": 0.2
        }
    },
    "emxarms:bayonet_emx_skyhunter_gw_data": {
        "weight": 0.24,
        "ads_addend": 0.05,
        "melee": {
            "range": [5, 1, 2],
            "damage": 20,
            "knockback": 0.0,
            "cooldown": -0.4,
            "delay_damage_time": 0.2
        }
    },
    "emxarms:bayonet_emx_skyhunter_yh_data": {
        "weight": 0.24,
        "ads_addend": 0.05,
        "melee": {
            "range": [6, 1, 2],
            "damage": 30,
            "knockback": 0.0,
            "cooldown": -0.2,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:glowing", "time": 30, "amplifier": 1, "hide_particles": false }
            ]
        }
    },
    "emxarms:bayonet_emx_skyhunterax_data": {
        "weight": 0.4,
        "ads_addend": 0.05,
        "recoil_modifier": {
            "pitch": -0.15,
            "yaw": -0.03
        },
        "melee": {
            "range": [5, 1, 2],
            "damage": 10,
            "knockback": 0.0,
            "cooldown": -0.2,
            "delay_damage_time": 0.2
        }
    },
    "emxarms:ammo_h1_data": {
        "weight": 0.4,
        "ads": { "addend": 0.04 },
        "damage": { "multiplier": 1.1 },
        "extended_mag_level": 1
    },
    "emxarms:ammo_h2_data": {
        "weight": 0.8,
        "ads": { "addend": 0.08 },
        "damage": { "multiplier": 1.1 },
        "extended_mag_level": 2
    },
    "emxarms:ammo_h2_if_data": {
        "weight": 1.0,
        "ads": { "percent": -0.08 },
        "inaccuracy": { "addend": 0.25 },
        "aim_inaccuracy": { "addend": 0.12 },
        "ammo_speed": { "percent": -0.2 },
        "rpm": { "multiplier": 0.95 },
        "extended_mag_level": 2,
        "ignite": { "entity": true },
        "damage": { "multiplier": 1.3 },
        "head_shot":{ "addend": 0.04 }
    },
    "emxarms:ammo_h3_data": {
        "weight": 1.2,
        "ads": { "addend": 0.12 },
        "damage": { "multiplier": 1.25 },
        "extended_mag_level": 3
    },
    "emxarms:ammo_h3r_data": {
        "weight": 2.4,
        "ads": { "addend": 0.1 },
        "damage": { "multiplier": 1.35 },
        "extended_mag_level": 3
    },
    "emxarms:bayonet_emx_skyhunter2_data": {
        "weight": 0.36,
        "ads_addend": 0.05,
        "melee": {
            "range": [6, 1, 2],
            "damage": 44,
            "knockback": 0.0,
            "cooldown": -0.2,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:glowing", "time": 20, "amplifier": 1, "hide_particles": false },
                { "id": "minecraft:wither", "time": 10, "amplifier": 6, "hide_particles": false }
            ]
        }
    },
    "emxarms:ammo_l1_data": {
        "weight": 0.4,
        "ads": { "addend": 0.04 },
        "damage": { "multiplier": 1.05 },
        "extended_mag_level": 1
    },
    "emxarms:ammo_l2_data": {
        "weight": 0.8,
        "ads": { "addend": 0.08 },
        "damage": { "multiplier": 1.1 },
        "extended_mag_level": 2
    },
    "emxarms:ammo_l2_hp_data": {
        "weight": 1.0,
        "ads": { "percent": 0.15 },
        "inaccuracy": { "addend": 0.25 },
        "aim_inaccuracy": { "addend": 0.16 },
        "ammo_speed": { "percent": -0.25 },
        "pierce": { "addend": -0.3 },
        "rpm": { "multiplier": 0.95 },
        "extended_mag_level": 2,
        "recoil": {
            "yaw": { "percent": 0.15 },
            "pitch": { "percent": 0.25 }
        },
        "damage": { "multiplier": 1.3 },
        "armor_ignore":{ "multiplier": 0.0 },
        "head_shot":{ "addend": -0.2 },
        "knockback": { "addend": -0.04 }
    },
    "emxarms:ammo_l2_if_data": {
        "weight": 0.8,
        "ads": { "percent": -0.12 },
        "inaccuracy": { "addend": 0.15 },
        "aim_inaccuracy": { "addend": 0.1 },
        "ammo_speed": { "percent": -0.2 },
        "rpm": { "multiplier": 0.95 },
        "extended_mag_level": 2,
        "ignite": { "entity": true },
        "damage": { "multiplier": 1.3 },
        "head_shot":{ "addend": 0.05 }
    },
    "emxarms:ammo_l3_data": {
        "weight": 1.2,
        "ads": { "addend": 0.12 },
        "damage": { "multiplier": 1.3 },
        "extended_mag_level": 3
    },
    "emxarms:ammo_l3r_data": {
        "weight": 2.4,
        "ads": { "addend": 0.12 },
        "damage": { "multiplier": 1.5 },
        "extended_mag_level": 3
    },
    "emxarms:ammo_sgap_data": {
        "weight": 0.85,
        "ads": { "percent": 0.08 },
        "inaccuracy": { "addend": 0.65 },
        "aim_inaccuracy": { "addend": -0.35 },
        "ammo_speed": { "percent": 0.08 },
        "pierce": { "addend": 0.5 },
        "extended_mag_level": 2,
        "armor_ignore":{ "addend": 0.35 },
        "head_shot":{ "addend": -0.15 }
    },
        "emxarms:sight_emx_char2_ev_data": {
        "weight": 0.2,
        "ads_addend": -0.06,
        "inaccuracy_addend": -0.1,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
    "emxarms:sight_emx_demo2_data": {
        "weight": 0.14,
        "ads_addend": -0.08,
        "aim_inaccuracy": {
            "addend": -0.04
        }
    },
    "emxarms:sight_emx_integer_data": {
        "weight": 0.15,
        "ads_addend": -0.09,
        "aim_inaccuracy": {
            "addend": -0.03
        }
    },
    "emxarms:sight_emx_koei1_data": {
        "weight": 0.28,
        "ads_addend": -0.15,
        "head_shot":{
            "addend": 0.02
        },
        "damage": {
            "percent": 0.02
        },
        "inaccuracy_addend": -0.08,
        "recoil_modifier": {
            "pitch": -0.1,
            "yaw": -0.1
        }
    },
    "emxarms:sight_emx_laterano_b_data": {
        "weight": 0.2,
        "inaccuracy_addend": -0.25,
        "ads_addend": -0.06
    },
    "emxarms:sight_emx_laterano_data": {
        "weight": 0.2,
        "inaccuracy_addend": -0.25,
        "ads_addend": -0.06
    },
    "emxarms:sight_emx_laterano_yh_data": {
        "weight": 0.22,
        "inaccuracy_addend": -0.26,
        "ads_addend": -0.06
    },
    "emxarms:sight_emx_return_data": {
        "weight": 0.2,
        "ads_addend": 0.07,
        "head_shot":{
            "addend": 0.03
        },
        "inaccuracy_addend": -0.1,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
    "emxarms:sight_emx_return_eos_data": {
        "weight": 0.2,
        "ads_addend": 0.07,
        "inaccuracy_addend": -0.1,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
    "emxarms:sight_emx_return_yh_data": {
        "weight": 0.2,
        "ads_addend": 0.08,
        "head_shot":{
            "addend": 0.03
        },
        "inaccuracy_addend": -0.19,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
    "emxarms:sight_emx_tanh_data": {
        "weight": 0.2,
        "ads_addend": -0.05,
        "inaccuracy_addend": -0.02,
        "recoil_modifier": {
            "pitch": -0.02
        }
    },
    "emxarms:stock_emx_reentrantlock_data": {
        "weight": 0.1,
        "ads_addend": 0.04,
        "recoil_modifier": {
            "pitch": 0.18,
            "yaw": -0.05
        },
        "inaccuracy_addend": -0.35,
        "melee": {
            "range": [5, 1, 2],
            "damage": 5,
            "knockback": 1.2,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:slowness", "time": 3, "amplifier": 2, "hide_particles": true },
                { "id": "minecraft:weakness", "time": 5, "amplifier": 2, "hide_particles": true }
            ]
        }
    },
    "emxarms:stock_emx_sleep_data": {
        "weight": 0.1,
        "ads_addend": 0.14,
        "recoil_modifier": {
            "pitch": -0.1,
            "yaw": -0.15
        },
        "melee": {
            "range": [5, 1, 2],
            "damage": 8,
            "knockback": 1.2,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:slowness", "time": 3, "amplifier": 2, "hide_particles": true },
                { "id": "minecraft:weakness", "time": 5, "amplifier": 2, "hide_particles": true }
            ]
        }
    },
    "emxarms:stock_emx_yield_data": {
        "weight": 0.1,
        "ads_addend": 0.15,
        "recoil_modifier": {
            "pitch": -0.28
        },
        "melee": {
            "range": [5, 1, 2],
            "damage": 15,
            "knockback": 1.5,
            "delay_damage_time": 0.2,
            "effects": [
                { "id": "minecraft:slowness", "time": 5, "amplifier": 2, "hide_particles": true },
                { "id": "minecraft:weakness", "time": 7, "amplifier": 2, "hide_particles": true }
            ]
        }
    },
    "emxarms:emx_heavyweight_mag_3_data": {
        "weight": 1.2,
        "ads_addend": 0.1,
        "inaccuracy_addend": -0.1,
        "damage": {
            "multiplier": 1.08
        },
        "recoil_modifier": {
            "pitch": -0.16,
            "yaw": -0.1
        },
        "extended_mag_level": 3
    },
    "emxarms:emx_lightweight_mag_2_data": {
        "weight": 0.2,
        "ads_addend": -0.05,
        "damage": {
            "multiplier": 1.06
        },
        "extended_mag_level": 2
    },
    "emxarms:emx_sfmag_1_data": {
        "weight": 2.0,
        "ads_addend": 0.1,
        "damage": {
            "multiplier": 1.1
        },
        "extended_mag_level": 1
    },
    "emxarms:emx_sfmag_1he_data": {
        "weight": 1.25,
        "ads": {
            "percent": 0.2
        },
        "inaccuracy": {
            "addend": 0.15
        },
        "aim_inaccuracy": {
            "addend": 0.3
        },
        "ammo_speed": {
            "percent": -0.12
        },
        "pierce": {
            "multiplier": 0.0
        },
        "extended_mag_level": 1,
        "explosion": {
            "explode": true,
            "radius": { "addend": 1.5 },
            "damage": { "addend": 25.0 },
            "knockback": false,
            "destroy_block": false,
            "delay": { "addend": 3.0 }
        },
        "damage": { "multiplier": 1.25 },
        "head_shot":{ "addend": 0.2 },
        "knockback": { "addend": 0.5 }
    },
    "emxarms:emx_sfmag_2_data": {
        "weight": 4.0,
        "ads_addend": 0.1,
        "damage": {
            "multiplier": 1.1
        },
        "extended_mag_level": 2
    },
    "emxarms:emx_sfmag_3_data": {
        "weight": 6.0,
        "ads_addend": 0.1,
        "damage": {
            "multiplier": 1.15
        },
        "extended_mag_level": 3
    },
    "emxarms:emx_sfmag_3if_data": {
        "weight": 3.2,
        "ads": {
            "percent": 0.08
        },
        "inaccuracy": {
            "addend": 0.15
        },
        "aim_inaccuracy": {
            "addend": 0.12
        },
        "ammo_speed": {
            "percent": -0.13
        },
        "pierce": {
            "addend": -2.0
        },
        "extended_mag_level": 3,
        "ignite": {
            "entity": true
        },
        "damage": {
            "multiplier": 1.15
        },
        "armor_ignore":{
            "addend": -0.1
        }
    },
    "emxarms:grip_emx_assert_data": {
        "weight": 0.25,
        "recoil_modifier": {
            "pitch": -0.1,
            "yaw": -0.2
        }
    },
    "emxarms:grip_emx_coder_data": {
        "weight": 0.15,
        "inaccuracy_addend": -0.6,
        "ads": {
            "addend": -0.035
        },
        "inaccuracy": {
            "addend": -0.15
        },
        "aim_inaccuracy": {
            "addend": -0.1
        },
        "head_shot":{
            "addend": 0.02
        }
    },
    "emxarms:grip_emx_compiler_data": {
        "weight": 0.25,
        "ads": {
            "addend": -0.035
        },
        "inaccuracy": {
            "addend": -0.58
        },
        "aim_inaccuracy": {
            "addend": -0.1
        },
        "armor_ignore":{
            "addend": 0.05
        }
    },
    "emxarms:grip_emx_double_data": {
        "weight": 0.15,
        "ads_addend": -0.025,
        "inaccuracy_addend": -0.6
    },
    "emxarms:grip_emx_double_h_data": {
        "weight": 0.15,
        "ads_addend": -0.025,
        "inaccuracy_addend": -0.6
    },
    "emxarms:grip_emx_double_yh_data": {
        "weight": 0.19,
        "ads_addend": -0.025,
        "inaccuracy_addend": -0.64
    },
    "emxarms:grip_emx_extends_data": {
        "weight": 0.2,
        "recoil_modifier": {
            "pitch": -0.3
        }
    },
    "emxarms:grip_emx_extendsex_data": {
        "weight": 0.25,
        "ads_addend": -0.02,
        "inaccuracy_addend": -0.8,
        "recoil_modifier": {
            "pitch": -0.32
        }
    },
    "emxarms:grip_emx_float_data": {
        "weight": 0.24,
        "recoil_modifier": {
            "yaw": -0.3
        }
    },
    "emxarms:grip_emx_if_data": {
        "weight": 0.35,
        "ads_addend": 0.02,
        "recoil_modifier": {
            "pitch": -0.2,
            "yaw": -0.23
        }
    },
    "emxarms:grip_emx_if_ev_data": {
        "weight": 0.37,
        "ads_addend": 0.02,
        "recoil_modifier": {
            "pitch": -0.21,
            "yaw": -0.23
        }
    },
    "emxarms:grip_emx_maxvalue_data": {
        "weight": 0.31,
        "ads_addend": -0.02,
        "inaccuracy_addend": -0.8,
        "recoil_modifier": {
            "pitch": -0.06,
            "yaw": -0.24
        }
    },
    "emxarms:grip_emx_nested_data": {
        "weight": 0.44,
        "ads_addend": -0.01,
        "inaccuracy_addend": -0.6,
        "recoil_modifier": {
            "pitch": -0.30,
            "yaw": -0.1
        }
    },
    "emxarms:grip_emx_protected_data": {
        "weight": 0.55,
        "ads_addend": 0.06,
        "recoil_modifier": {
            "pitch": -0.34,
            "yaw": -0.15
        }
    },
    "emxarms:grip_emx_static_data": {
        "weight": 4.85,
        "ads_addend": 0.18,
        "inaccuracy_addend": -0.25,
        "recoil_modifier": {
            "pitch": -0.82,
            "yaw": -0.55
        }
    },
    "emxarms:grip_emx_synchronized_data": {
        "weight": 0.2,
        "ads_addend": 0.04,
        "recoil_modifier": {
            "pitch": -0.34,
            "yaw": -0.15
        }
    },
    "emxarms:grip_emx_synchronized_yh_data": {
        "weight": 0.25,
        "ads_addend": 0.04,
        "recoil_modifier": {
            "pitch": -0.38,
            "yaw": -0.18
        }
    },
    "emxarms:grip_emx_wireframe_data": {
        "weight": 0.2,
        "ads": {
            "percent": -0.15
        },
        "inaccuracy": {
            "addend": -0.12
        },
        "aim_inaccuracy": {
            "addend": -0.45
        },
        "head_shot":{
            "addend": 0.04
        }
    },
    "emxarms:grip_emx_wireframedb_data": {
        "weight": 0.32,
        "ads": {
            "percent": -0.19
        },
        "inaccuracy": {
            "addend": -0.42
        },
        "aim_inaccuracy": {
            "addend": -0.48
        },
        "head_shot":{
            "addend": 0.05
        }
    },
    "emxarms:grip_emx_wireframeex_data": {
        "weight": 0.4,
        "ads": {
            "percent": -0.15
        },
        "recoil_modifier": {
            "pitch": -0.32
        },
        "inaccuracy": {
            "addend": -0.12
        },
        "aim_inaccuracy": {
            "addend": -0.45
        },
        "head_shot":{
            "addend": 0.04
        }
    },
    "emxarms:laser_emx_compiler_data": {
        "weight": 0.25,
        "ads": {
            "addend": -0.035
        },
        "inaccuracy": {
            "addend": -0.58
        },
        "aim_inaccuracy": {
            "addend": -0.1
        },
        "armor_ignore":{
            "addend": 0.05
        }
    },
    "emxarms:muzzle_emx_catch_data": {
        "weight": 0.15,
        "inaccuracy_addend": -0.15,
        "recoil_modifier": {
            "pitch": -0.25
        }
    },
    "emxarms:muzzle_emx_encapsulation_data": {
        "weight": 0.15,
        "inaccuracy_addend": -0.55,
        "recoil_modifier": {
            "pitch": -0.15,
            "yaw": -0.03
        }
    },
    "emxarms:muzzle_emx_encapsulationse_data": {
        "weight": 0.15,
        "inaccuracy_addend": -0.15
    },
    "emxarms:muzzle_emx_throw_data": {
        "weight": 0.15,
        "inaccuracy_addend": -0.16,
        "recoil_modifier": {
            "yaw": -0.25
        }
    },
    "emxarms:muzzle_sf7b_super6_data": {
        "weight": -15.8,
        "ads": {
            "percent": -0.65
        },
        "inaccuracy": {
            "addend": 0.25
        },
        "aim_inaccuracy": {
            "addend": 0.15
        },
        "ammo_speed": {
            "percent": 0.1
        },
        "pierce": {
            "addend": -1.0
        },
        "rpm": {
            "addend": 120.0
        },
        "silence": {
            "distance_addend": -10,
            "use_silence_sound": true
        },
        "recoil": {
            "yaw": { "percent": -0.15 },
            "pitch": { "percent": -0.5 }
        },
        "damage": { "multiplier": 1.1 },
        "armor_ignore":{ "multiplier": 0.9 },
        "head_shot":{ "addend": -0.1 }
    },
    "emxarms:laser_emx_double_data": {
        "weight": 0.15,
        "ads_addend": -0.025,
        "inaccuracy_addend": -0.6
    },
    "emxarms:muzzle_sf7b_uac9000_data": {
        "weight": 18.8,
        "ads": {
            "percent": 0.15
        },
        "inaccuracy": {
            "addend": 0.25
        },
        "aim_inaccuracy": {
            "addend": 0.25
        },
        "ammo_speed": {
            "percent": 0.1
        },
        "pierce": {
            "addend": 1.0
        },
        "rpm": {
            "addend": -50.0
        },
        "silence": {
            "distance_addend": 10,
            "use_silence_sound": false
        },
        "recoil": {
            "yaw": { "percent": 0.15 },
            "pitch": { "percent": 0.3 }
        },
        "damage": { "multiplier": 1.1 },
        "armor_ignore":{ "multiplier": 1.1 },
        "head_shot":{ "addend": 0.1 }
    },
    "emxarms:sight_emx_anonymous_data": {
        "weight": 0.3,
        "ads_addend": -0.06,
        "recoil_modifier": {
            "pitch": -0.07
        }
    },
    "emxarms:sight_emx_anonymous_gw_data": {
        "weight": 0.3,
        "ads_addend": -0.07,
        "head_shot":{
            "addend": 0.03
        },
        "recoil_modifier": {
            "pitch": -0.1
        }
    },
    "emxarms:sight_emx_aps_data": {
        "weight": 0.48,
        "head_shot":{
            "addend": 0.05
        },
        "ads_addend": -0.08,
        "inaccuracy_addend": -0.24
    },
    "emxarms:sight_emx_array_data": {
        "weight": 0.2,
        "ads_addend": 0.12,
        "head_shot":{
            "addend": 0.05
        },
        "inaccuracy_addend": -0.05,
        "recoil_modifier": {
            "pitch": -0.04
        }
    },
    "emxarms:sight_emx_aw_ba_data": {
        "weight": 0.15,
        "ads_addend": -0.07,
        "inaccuracy_addend": -0.1,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
    "emxarms:sight_emx_aw_h_data": {
        "weight": 0.15,
        "ads_addend": -0.05,
        "inaccuracy_addend": -0.1,
        "recoil_modifier": {
            "pitch": -0.4
        }
    },
    "emxarms:sight_emx_char1_data": {
        "weight": 0.2,
        "inaccuracy_addend": -0.1,
        "ads_addend": -0.08
    },
    "emxarms:sight_emx_char2_data": {
        "weight": 0.2,
        "ads_addend": -0.04,
        "recoil_modifier": {
            "pitch": -0.05
        }
    },
};

TaCZServerEvents.attachmentDataLoad((e) => {
    let 配件ID = e.getId().toString();

    if (EMX配件数据.hasOwnProperty(配件ID)) {
        let 数据对象 = EMX配件数据[配件ID];
        e.setJson(JSON.stringify(数据对象));
    }
});